package com.qboxus.tictic.activitesfragments.livestreaming.fragments;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.LinearLayoutManager;

import com.qboxus.tictic.Constants;
import com.qboxus.tictic.R;
import com.qboxus.tictic.activitesfragments.livestreaming.adapter.PkBattleAdapter;
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveUserModel;
import com.qboxus.tictic.apiclasses.ApiLinks;
import com.qboxus.tictic.databinding.FragmentPkBattleInviteBinding;
import com.qboxus.tictic.interfaces.AdapterClickListener;
import com.qboxus.tictic.interfaces.FragmentCallBack;
import com.qboxus.tictic.simpleclasses.Dialogs;
import com.qboxus.tictic.simpleclasses.Functions;
import com.qboxus.tictic.simpleclasses.TicTicApp;
import com.qboxus.tictic.simpleclasses.Variables;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.volley.plus.VPackages.VolleyRequest;
import com.volley.plus.interfaces.Callback;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

public class PkBattleInviteFragment extends BottomSheetDialogFragment {
    public Handler handler;
    public Runnable runable;
    DatabaseReference rootref;
    FragmentPkBattleInviteBinding binding;
    ArrayList<LiveUserModel> friendsDataList = new ArrayList<>();
    ArrayList<LiveUserModel> recomendedDataList = new ArrayList<>();
    PkBattleAdapter friendsAdapter, recomendedAdapter;
    FragmentCallBack fragmentCallBack;
    ArrayList<LiveUserModel> dataList = new ArrayList<>();
    ChildEventListener valueEventListener;

    public PkBattleInviteFragment(FragmentCallBack fragmentCallBack) {
        this.fragmentCallBack = fragmentCallBack;
    }

    public static PkBattleInviteFragment newInstance(FragmentCallBack fragmentCallBack) {
        PkBattleInviteFragment fragment = new PkBattleInviteFragment(fragmentCallBack);
        Bundle args = new Bundle();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        rootref = FirebaseDatabase.getInstance().getReference();
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_pk_battle_invite, container, false);


        binding.recyclerviewFriends.setLayoutManager(new LinearLayoutManager(getContext()));
        binding.recyclerviewFriends.setHasFixedSize(true);
        friendsAdapter = new PkBattleAdapter(getContext(), friendsDataList, new AdapterClickListener() {
            @Override
            public void onItemClick(View view, int pos, Object object) {
                if (view.getId() == R.id.action_txt) {
                    LiveUserModel liveUserModel = (LiveUserModel) object;
                    Bundle bundle = new Bundle();
                    bundle.putParcelable("data", liveUserModel);
                    fragmentCallBack.onResponce(bundle);
                    dismiss();
                }

            }
        });
        binding.recyclerviewFriends.setAdapter(friendsAdapter);


        binding.recyclerviewRecomended.setLayoutManager(new LinearLayoutManager(getContext()));
        binding.recyclerviewRecomended.setHasFixedSize(true);
        recomendedAdapter = new PkBattleAdapter(getContext(), recomendedDataList, new AdapterClickListener() {
            @Override
            public void onItemClick(View view, int pos, Object object) {
                if (view.getId() == R.id.action_txt) {
                    LiveUserModel liveUserModel = (LiveUserModel) object;
                    Bundle bundle = new Bundle();
                    bundle.putParcelable("data", liveUserModel);
                    fragmentCallBack.onResponce(bundle);
                    dismiss();
                }

            }
        });
        binding.recyclerviewRecomended.setAdapter(recomendedAdapter);


        addDataListener();
        return binding.getRoot();
    }

    public void addDataListener() {

        valueEventListener = new ChildEventListener() {
            @Override
            public void onChildAdded(@NonNull DataSnapshot dataSnapshot, @Nullable String s) {
                if (dataSnapshot.exists()) {
                    Functions.printLog(Constants.tag, dataSnapshot.toString());

                    try {
                        LiveUserModel model = dataSnapshot.getValue(LiveUserModel.class);
                        if (Functions.isStringHasValue(model.getUserId()) && !Functions.getSharedPreference(getContext()).getString(Variables.U_ID, "").equalsIgnoreCase(model.getUserId())) {

                            if (TicTicApp.Companion.getAllOnlineUser().containsKey(model.getUserId())) {
                                if (model.getOnlineType().equalsIgnoreCase("multicast")) {
                                    dataList.add(model);
                                    timerCallApi();
                                }
                            }
                        }
                    }catch (Exception e){
                    }
                }
            }

            @Override
            public void onChildChanged(@NonNull DataSnapshot dataSnapshot, @Nullable String s) {

            }

            @Override
            public void onChildRemoved(@NonNull DataSnapshot dataSnapshot) {
                try {
                    if (dataSnapshot.exists()) {
                        LiveUserModel model = dataSnapshot.getValue(LiveUserModel.class);
                        if (model.getUserId() != null && !(TextUtils.isEmpty(model.getUserId())) && !(TextUtils.isEmpty(model.getUserId())) && !(model.getUserId().equals("null"))) {
                            for (int i = 0; i < friendsDataList.size(); i++) {
                                if (model.getUserId().equals(friendsDataList.get(i).getUserId())) {
                                    friendsDataList.remove(i);
                                }
                            }
                            for (int i = 0; i < recomendedDataList.size(); i++) {
                                if (model.getUserId().equals(recomendedDataList.get(i).getUserId())) {
                                    recomendedDataList.remove(i);
                                }
                            }

                            for (int i = 0; i < dataList.size(); i++) {
                                if (model.getUserId().equals(dataList.get(i).getUserId())) {
                                    dataList.remove(i);
                                }
                            }


                            friendsAdapter.notifyDataSetChanged();
                            recomendedAdapter.notifyDataSetChanged();

                            if (friendsDataList.isEmpty()) {
                                binding.nodataFriends.setVisibility(View.VISIBLE);
                            } else {
                                binding.nodataFriends.setVisibility(View.GONE);
                            }

                            if (recomendedDataList.isEmpty()) {
                                binding.nodataRecommend.setVisibility(View.VISIBLE);
                            } else {
                                binding.nodataRecommend.setVisibility(View.GONE);
                            }
                        }

                    }
                }catch (Exception e){}
            }

            @Override
            public void onChildMoved(@NonNull DataSnapshot dataSnapshot, @Nullable String s) {

            }

            @Override
            public void onCancelled(@NonNull DatabaseError databaseError) {
            }

        };


        rootref.child("LiveStreamingUsers").addChildEventListener(valueEventListener);
    }

    public void removeDataListener() {
        if (valueEventListener != null && rootref != null) {
            rootref.child("LiveStreamingUsers").removeEventListener(valueEventListener);
        }
    }

    public void timerCallApi() {
        if (handler != null & runable != null)
            handler.removeCallbacks(runable);

        if (handler == null) ;
        handler = new Handler(Looper.getMainLooper());

        if (runable == null)
            runable = new Runnable() {
                @Override
                public void run() {

                    callApi();
                }
            };

        handler.postDelayed(runable, 1000);
    }


    public void callApi() {
        JSONObject params = new JSONObject();
        try {
            params.put("user_id", Variables.sharedPreferences.getString(Variables.U_ID, ""));

            JSONArray array = new JSONArray();
            for (int i = 0; i < dataList.size(); i++) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("user_id", dataList.get(i).getUserId());
                array.put(jsonObject);
            }
            params.put("users", array);
        } catch (Exception e) {
            e.printStackTrace();
        }

        Functions.showLoader(getActivity(), false, false);
        VolleyRequest.JsonPostRequest(getActivity(), ApiLinks.showUsers, params, Functions.getHeaders(getActivity()), new Callback() {
            @Override
            public void onResponce(String resp) {
                Functions.checkStatus(getActivity(), resp);
                Functions.cancelLoader();

                try {
                    JSONObject jsonObject = new JSONObject(resp);
                    String code = jsonObject.optString("code");
                    if (code != null && code.equals("200")) {

                        JSONArray msg = jsonObject.optJSONArray("msg");

                        friendsDataList.clear();
                        recomendedDataList.clear();

                        for (int i = 0; i < msg.length(); i++) {
                            JSONObject data = msg.optJSONObject(i);
                            JSONObject user = data.optJSONObject("User");
                            String button = user.optString("button");
                            if (button.equalsIgnoreCase("friends")) {
                                friendsDataList.add(dataList.get(i));
                            } else {
                                recomendedDataList.add(dataList.get(i));
                            }
                        }

                        if (friendsDataList.isEmpty()) {
                            binding.nodataFriends.setVisibility(View.VISIBLE);
                        } else {
                            binding.nodataFriends.setVisibility(View.GONE);
                        }

                        if (recomendedDataList.isEmpty()) {
                            binding.nodataRecommend.setVisibility(View.VISIBLE);
                        } else {
                            binding.nodataRecommend.setVisibility(View.GONE);
                        }


                        friendsAdapter.notifyDataSetChanged();
                        recomendedAdapter.notifyDataSetChanged();

                    } else {
                        Dialogs.showAlert(getActivity(), getActivity().getApplicationContext().getString(R.string.server_error), jsonObject.optString("msg"));
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }


            }
        });

    }


    @Override
    public void onDestroy() {
        removeDataListener();
        super.onDestroy();
    }

}